package gov.va.genisis2.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * The Class UserRoleType.
 * 
 * Description: In this UserRoleType Class implements the interface Serializable
 * and defines the entity and data mapping for the dbo.User_Role_Type Table in
 * the database.
 * 
 */
@Entity
@Table(name = "User_Role_Type", schema = "dbo")
public class UserRoleType implements Serializable {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 1129913211978526467L;

	/** The id. */
	@Id
	@Column(name = "Id", unique = true, nullable = false)
	private int id;
	
	/** The role type id. */
	@Column(name = "Role_Type_id", nullable = false, insertable = false, updatable = false)
	private int roleTypeId;

	/** The role type. */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "Role_Type_id", nullable = false)
	private RoleType roleType;

	/** The user type id. */
	@Column(name = "User_Type_id", nullable = false, insertable = false, updatable = false)
	private int userTypeId;
	
	/** The user type. */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "User_Type_id", nullable = false)
	private UserType userType;

	/** The user id. */
	@Column(name = "User_id", nullable = false, insertable = false, updatable = false)
	private int userId;
	
	/** The user. */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "User_id", nullable = false)
	private User user;
	
	/** The start date. */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "Start_Date", nullable = false, length = 23)
	private Date startDate;
	
	/** The end date. */
	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "End_Date", length = 23)
	private Date endDate;

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	public int getId() {
		return this.id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id the new id
	 */
	public void setId(int id) {
		this.id = id;
	}
	
	public int getRoleTypeId() {
		return roleTypeId;
	}
	
	public void setRoleTypeId(int roleTypeId) {
		this.roleTypeId = roleTypeId;
	}

	/**
	 * Gets the role type.
	 *
	 * @return the role type
	 */
	public RoleType getRoleType() {
		return this.roleType;
	}

	/**
	 * Sets the role type.
	 *
	 * @param roleType the new role type
	 */
	public void setRoleType(RoleType roleType) {
		this.roleType = roleType;
	}
	
	public int getUserId() {
		return userId;
	}
	
	public void setUserId(int userId) {
		this.userId = userId;
	}

	/**
	 * Gets the user.
	 *
	 * @return the user
	 */
	public User getUser() {
		return this.user;
	}

	/**
	 * Sets the user.
	 *
	 * @param user the new user
	 */
	public void setUser(User user) {
		this.user = user;
	}

	/**
	 * Gets the userTypeId.
	 *
	 * @return the userTypeId
	 */
	public int getUserTypeId() {
		return userTypeId;
	}
	
	/**
	 * returns userTypeId
	 * 
	 * @param userTypeId the new userTypeId
	 */
	public void setUserTypeId(int userTypeId) {
		this.userTypeId = userTypeId;
	}
	
	/**
	 * Gets the user type.
	 *
	 * @return the user type
	 */
	public UserType getUserType() {
		return this.userType;
	}

	/**
	 * Sets the user type.
	 *
	 * @param userType the new user type
	 */
	public void setUserType(UserType userType) {
		this.userType = userType;
	}

	/**
	 * Gets the start date.
	 *
	 * @return the start date
	 */
	public Date getStartDate() {
		return this.startDate;
	}

	/**
	 * Sets the start date.
	 *
	 * @param startDate the new start date
	 */
	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	/**
	 * Gets the end date.
	 *
	 * @return the end date
	 */
	public Date getEndDate() {
		return this.endDate;
	}

	/**
	 * Sets the end date.
	 *
	 * @param endDate the new end date
	 */
	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}
}
